﻿using System.Collections.Generic;
using System.ComponentModel;
using System.Globalization;
using VIRP.EFR.BO;
using VIRP.CRS.BO;
using VIRP.CRS.BLL;
using System.Data;

namespace VIRP.EFR.BLL
{
    public static class QuestionnnaireManager
    {
        /// <summary>
        /// useful function to convert to various nullable types from string
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="input"></param>
        /// <returns></returns>
        public static T? ConvertStringToNullable<T>(string input) where T : struct
        {
            T? result = null;

            TypeConverter converter = TypeDescriptor.GetConverter(typeof(T));

            if (string.IsNullOrEmpty(input))
                result = null;
            else
                result = (T)converter.ConvertFromString(input);

            return result;
        }
        public static List<KeyValuePair<int, string>> GetVAMCReferralList(string userId, int registryId)
        {
            List<KeyValuePair<int, string>> objReturn = new List<KeyValuePair<int, string>>();

            List<QUES_STD_VAMC> lsi = QUES_STD_VAMCManager.GetItems(userId, registryId);

            foreach (QUES_STD_VAMC vamc in lsi)
            {
                objReturn.Add(new KeyValuePair<int, string>(vamc.ID, vamc.NAME));
            }

            return objReturn;
        }
        public static Dictionary<int, string> GetMonthNames()
        {
            DateTimeFormatInfo mfi = new DateTimeFormatInfo();

            var dictionary = new Dictionary<int, string>();

            dictionary.Add(0, "(unknown)");
            for (int month = 1; month <= 12; month++)
            {
                dictionary.Add(month, mfi.GetMonthName(month));
            }

            return dictionary;
        }
        public static Dictionary<int, string> GetMonthDays()
        {
            var dictionary = new Dictionary<int, string>();

            dictionary.Add(0, "(unknown)");

            for (int day = 1; day <= 31; day++)
            {
                dictionary.Add(day, day.ToString());
            }

            return dictionary;
        }

        public static List<KeyValuePair<int, string>> GetInjuryLocationList(string userId, int registryId)
        {
            List<KeyValuePair<int, string>> objReturn = new List<KeyValuePair<int, string>>();

            List<STD_COMBATLOCATION> lsi = STD_COMBATLOCATIONManager.GetItems(userId, registryId);
            //int[] iLocIds = { 1506506, 1617779, 1617777, 1617780 };
            List<int> ids = new List<int> { 1506506, 1617779, 1617777, 1617780 };

            foreach (STD_COMBATLOCATION cl in lsi)
            {
                if (ids.Contains(cl.ID))
                {
                    objReturn.Add(new KeyValuePair<int, string>(cl.ID, cl.NAME));
                }
            }

            return objReturn;
        }
    }
}
